class TablesController < ApplicationController
  def find_all_application_tables
    render :amf => ApplicationTable.find(:all)
  end

  def update_application_tables
    ApplicationTable.transaction do
      ApplicationTable.delete_all

      params[0].each do |param|
        application_table = ApplicationTable.new

        application_table.id = param.id
        application_table.domain_id = param.domain_id
        application_table.name = param.name

        application_table.save
      end
    end
  end


  def find_all_table_columns
    render :amf => TableColumn.find(:all)
  end

  def find_table_columns
    render :amf => TableColumn.find(:all, :conditions => ["table_id = ?", params[0].to_i]);
  end

  def update_table_columns
    TableColumn.transaction do
      TableColumn.delete_all

      params[0].each do |param|
        table_column = TableColumn.new

        table_column.id = param.id
        table_column.domain_id = param.domain_id
        table_column.table_type = param.table_type
        table_column.table_id = param.table_id
        table_column.name = param.name
        table_column.type = param.type
        table_column.length = param.length
        table_column.relation_table_name = param.relation_table_name
        table_column.relation_item_name = param.relation_item_name
        table_column.polymorphic = param.polymorphic
        table_column.dependent = param.dependent
        table_column.application_key = param.application_key
        
        table_column.save
      end
    end
  end
end
